IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CF_PagoFacil_TX]') 
                   and [type] = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_PagoFacil_TX
END
GO

CREATE FUNCTION [dbo].[CF_PagoFacil_TX](@pId_Trans INT, @pImporte DECIMAL(12,2)) 
RETURNS CHAR(200)
AS
BEGIN

/*Variable de Retorno*/
DECLARE @Retorno			CHAR(200)
/*FIN Variable de Retorno*/

/*Variables del Archivo*/
DECLARE @aTipoRegistro		CHAR(2)	/*LONG: 02. Detalle de Registro. Valor "02"*/
DECLARE @aIdentPrimario		CHAR(21)/*LONG: 21. Clave Primaria para bsqueda*/
DECLARE @aIdentSecundario	CHAR(30)/*LONG: 30. Clave Secundaria para bsqueda*/
DECLARE @aNroSecuencia		CHAR(6)	/*LONG: 06. */
DECLARE @aMensaje			CHAR(20)/*LONG: 20. Mensaje a mostrar para el registro.*/
DECLARE @aNombreCliente		CHAR(40)/*LONG: 40. */
DECLARE @aCodBarra			CHAR(55)/*LONG: 55. */
DECLARE @aFechaVigencia		CHAR(8)	/*LONG: 08. Formato: AAAAMMDD*/
DECLARE @aFechaVencimiento	CHAR(8)	/*LONG: 08. Formato: AAAAMMDD*/
DECLARE @aTipoPago			CHAR(1)	/*LONG: 01. Valores Posibles: "T": Pago Total | "P": Pago Parcial | "A": Monto Abierto*/
DECLARE @aFiller			CHAR(9)	/*LONG: 09. */
/*FIN Variables del Archivo*/


/*Variables Intermedias*/
DECLARE @TipoIdentPrim	INT
DECLARE @Id_Cliente		INT
DECLARE @Id_Cliente_Externo VARCHAR(14)
DECLARE @Doc_Nro		BIGINT
DECLARE @Anio_Periodo	CHAR(4)
DECLARE @Mes_Periodo	CHAR(2)
DECLARE @Fecha_Cbte		DATETIME
DECLARE @Fecha_Hoy		DATETIME
DECLARE @Fecha_Hoy_MasUnMes	DATETIME
DECLARE @Anio_Hoy		CHAR(4)
DECLARE @Mes_Hoy		CHAR(2)
DECLARE @Dia_Hoy		CHAR(2)
DECLARE @Fecha_Venc		DATETIME
DECLARE @Anio_Venc		CHAR(4)
DECLARE @Mes_Venc		CHAR(2)
DECLARE @Dia_Venc		CHAR(2)
/*FIN Variables Intermedias*/

/*=================================================================================*/

SET @aTipoRegistro	= '02'

SET @Id_Cliente		= ISNULL((SELECT ISNULL(Id_Cliente, 0) FROM Cbtes WHERE Id_Trans = @pId_Trans),0)
SET @Doc_Nro		= ISNULL((SELECT ISNULL(Doc_Nro, 0) FROM Clientes WHERE Id_Cliente = @Id_Cliente), 0)
SET @Id_Cliente_Externo = ISNULL((SELECT RTRIM(LTRIM(ISNULL(Id_Cliente_Externo, ''))) FROM Clientes WHERE Id_Cliente = @Id_Cliente), '')

SET @TipoIdentPrim = ISNULL(dbo.CF_xParam('PagoFacil_IdentPrim'), 0)

IF(@TipoIdentPrim = 0) /*Doc_Nro*/
BEGIN
	SET @aIdentPrimario = (RIGHT( '000000000000000000000' + CAST(@Doc_Nro AS VARCHAR), 21))
END

IF(@TipoIdentPrim = 1) /*Id_Cliente_Externo*/
BEGIN
	SET @aIdentPrimario = (RIGHT( '000000000000000000000' + CAST(@Id_Cliente_Externo AS VARCHAR), 21))
END

IF(@TipoIdentPrim = 2) /*Id_Cliente*/
BEGIN
	SET @aIdentPrimario = (RIGHT( '000000000000000000000' + CAST(@Id_Cliente AS VARCHAR), 21))
END



SET @aIdentSecundario = (CONVERT(CHAR(30), CAST(@pId_Trans AS VARCHAR)))

/*Nmero de Secuencia*/
SET @Fecha_Cbte		= (SELECT ISNULL(Fecha, '19000101') FROM Cbtes WHERE Id_Trans = @pId_Trans)
SET @Anio_Periodo	= CAST(DATEPART(YY,@Fecha_Cbte) AS CHAR(4))
SET @Mes_Periodo	= RIGHT('00' + CAST(MONTH(@Fecha_Cbte) AS VARCHAR),2)

SET @aNroSecuencia = @Anio_Periodo + @Mes_Periodo
/*FIN Nmero de Secuencia*/

SET @aMensaje = 'DEUDA AL ' + @Mes_Periodo + '/' + @Anio_Periodo

SET @aNombreCliente	= (SELECT SUBSTRING(ISNULL(Razon_Social, ''),0,20) FROM Clientes WHERE Id_Cliente = @Id_Cliente)

SET @aCodBarra = ISNULL((SELECT dbo.CF_PagoFacil_CB_TX(@pId_Trans, @pImporte)), '                                                       ')

/*Fecha Vigencia, se pidi en el ticket 9315. 19/04/2017 que Fecha de Vigencia sea el da actual*/
SET @Fecha_Hoy	= GETDATE()

SET @Anio_Hoy	= CAST(DATEPART(YY,@Fecha_Hoy) AS CHAR(4))
SET @Mes_Hoy	= RIGHT('00' + CAST(MONTH(@Fecha_Hoy) AS VARCHAR),2)
SET @Dia_Hoy	= RIGHT('00' + CAST(DAY(@Fecha_Hoy) AS VARCHAR),2)

SET @aFechaVigencia = @Anio_Hoy + @Mes_Hoy + @Dia_Hoy
/*FIN Fecha Vigencia*/

/*Fecha Vencimiento, se pidi en el ticket 9315. 19/04/2017 que Fecha Vencimiento sea un mes mas de la fecha Actual*/
SET @Fecha_Hoy_MasUnMes = DATEADD(mm,1,GETDATE())

SET @Anio_Venc	= CAST(DATEPART(YY,@Fecha_Hoy_MasUnMes) AS CHAR(4))
SET @Mes_Venc	= RIGHT('00' + CAST(MONTH(@Fecha_Hoy_MasUnMes) AS VARCHAR),2)
SET @Dia_Venc	= RIGHT('00' + CAST(DAY(@Fecha_Hoy_MasUnMes) AS VARCHAR),2)

SET @aFechaVencimiento = @Anio_Venc + @Mes_Venc + @Dia_Venc
/*FIN Fecha Vencimiento*/

SET @aTipoPago = 'T'

SET @aFiller = '         '

/*=================================================================================*/

SET @retorno =	@aTipoRegistro		+
				@aIdentPrimario		+
				@aIdentSecundario	+
				@aNroSecuencia		+
				@aMensaje			+ 
				@aNombreCliente		+
				@aCodBarra			+
				@aFechaVigencia		+
				@aFechaVencimiento	+
				@aTipoPago			+
				@aFiller		

RETURN @retorno
END